DEFINE SOBEL (y = !charend('/')/x = !charend('/')/m = !charend('/')/boot =
!charend('/')).
SET MXLOOPS = 10000001.
MATRIX.

get dd/variables = !y !x !m/MISSING = OMIT.
compute n = nrow(dd).

do if (!boot > 999).
compute btn = trunc(!boot/1000)*1000.
compute btnp = btn+1.
else.
compute btn = 1000.
compute btnp = btn+1.
end if.
compute res=make(btnp,1,0).
compute dat=dd.

loop #j = 1 to btnp.
do if (#j = 2 and !boot < 1000).
BREAK.
end if.

do if (#j > 1).
loop #m = 1 to n.
compute v=trunc(uniform(1,1)*n)+1.
compute dat(#m,1:3)=dd(v,1:3).
end loop.
end if.

compute y = dat(:,1).
compute x = dat(:,2).
compute z = dat(:,3).
compute xz = dat(:,2:3).

compute con = make(n,1,1).
compute xo = {con,x}.
compute bzx = inv(t(xo)*xo)*t(xo)*z.
compute bzx = bzx(2,1).
compute xzo = {con,xz}.
compute byzx2 = inv(t(xzo)*xzo)*t(xzo)*y.
compute byzx = byzx2(3,1).
compute byxz = byzx2(2,1).
compute ind = bzx*byzx.
compute res(#j,1) = ind.

do if (#j = 1).
compute sd = sqrt(((n*cssq(dat))-(csum(dat)&**2))/((n-1)*n)).
compute num = (n*sscp(dat)-(transpos(csum(dat))*(csum(dat)))).
compute den = sqrt(transpos((n*cssq(dat))-
(csum(dat)&**2))*((n*cssq(dat))-
(csum(dat)&**2))).
compute r = num&/den.
compute sdbzx = (sd(1,3)/sd(1,2))*sqrt((1-(r(3,2)*r(3,2)))/(n-2)).
compute ryi = r(2:3,1).
compute rii = r(2:3,2:3).
compute bi=inv(rii)*ryi.
compute rsq = t(ryi)*bi.
compute sec=sqrt((1-rsq)/(n-3))*sqrt(1/(1-(r(3,2)*r(3,2)))).
compute sdyzx = (sd(1,1)/sd(1,3))*sec.
compute sdyxz = (sd(1,1)/sd(1,2))*sec.
compute seind =
sqrt(((byzx*byzx)*(sdbzx*sdbzx))+((bzx*bzx)*(sdyzx*sdyzx))+
((sdbzx*sdbzx)*(sdyzx*sdyzx))).
compute byx = r(2,1)*sd(1,1)/sd(1,2).
compute sebyx = (sd(1,1)/sd(1,2))*sqrt((1-(r(2,1)*r(2,1)))/(n-2)).
compute se = {sebyx; sdbzx; sdyzx; sdyxz}.
compute bb = {byx; bzx; byzx; byxz}.
compute tt = bb&/se.
compute p =2*(1-tcdf(abs(tt),n-2)).
compute p(3,1)=2*(1-tcdf(abs(tt(3,1)),n-3)).
compute p(4,1)=2*(1-tcdf(abs(tt(4,1)),n-3)).
compute tst = ind/seind.
compute bw = {bb,se,tt,p}.
compute p2=2*(1-cdfnorm(abs(tst))).
compute LL95 = ind-1.96*seind.
compute UL95=ind+1.96*seind.
compute op={ind, seind, LL95,UL95, tst, p2}.
end if.
end loop.

compute res = res(2:btnp,1).
compute mnbt = csum(res)/btn.
compute se = (sqrt(((btn*cssq(res))-(csum(res)&**2))/((btn-1)*btn))).

do if (!boot > 999).
compute res = {-999;res}.
loop #i = 2 to btnp.
compute ix = res(#i,1).
loop #k= #i to 2 by -1.
compute k = #k.
do if (res(#k-1,1) > ix).
compute res(#k,1)=res(#k-1,1).
else if (res(#k-1,1) <= ix).
BREAK.
end if.
end loop.
compute res(k,1)=ix.
end loop.
compute res = res(2:btnp,1).
end if.


compute lower99 = res(.005*btn,1).
compute lower95 = res(.025*btn,1).
compute upper95 = res(1+.975*btn,1).
compute upper99 = res(1+.995*btn,1).
compute bt = {mnbt, se, lower95, upper95, lower99, upper99}.

print bw/title = "DIRECT AND TOTAL EFFECTS"/clabels = "Coeff" "s.e." "t "
"Sig(two)"/rlabels = "b(YX)" "b(MX)" "b(YM.X)" "b(YX.M)"/format f9.4.
print op/title = "INDIRECT EFFECT AND SIGNIFICANCE USING NORMAL DISTRIBUTION"
/rlabels= " Sobel" /clabels = "Value" "s.e." "LL 95 CI" "UL 95 CI" "Z"
"Sig(two)"/format f9.4.
do if (!boot > 999).
print bt/title = "BOOTSTRAP RESULTS FOR INDIRECT EFFECT"
/rlabels ="Effect"
/clabels = "Mean" "s.e." "LL 95 CI" "UL 95 CI" "LL 99 CI" "UL 99 CI"/format f9.4.
print n/title = "SAMPLE SIZE"/format F8.0.
print btn/title = "NUMBER OF BOOTSTRAP RESAMPLES"/format F8.0.
end if.
END MATRIX.
!END DEFINE.

SOBEL y = suicide/x = prestige/m = educatio/boot = 1000/.